/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.condition.common.MorbidCondition;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class GrimReapersSprintCostModificationEffect
extends CostModificationEffectImpl {
    GrimReapersSprintCostModificationEffect() {
        super(Duration.EndOfGame, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "this spell costs {3} less to cast if a creature died this turn";
    }

    private GrimReapersSprintCostModificationEffect(GrimReapersSprintCostModificationEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)3);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (abilityToModify.getSourceId().equals(source.getSourceId()) && abilityToModify instanceof SpellAbility) {
            return MorbidCondition.instance.apply(game, abilityToModify);
        }
        return false;
    }

    public GrimReapersSprintCostModificationEffect copy() {
        return new GrimReapersSprintCostModificationEffect(this);
    }
}

