/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GrimdancerEffect
extends OneShotEffect {
    private static final Set<String> choices = new LinkedHashSet<String>();

    GrimdancerEffect() {
        super(Outcome.Benefit);
        this.staticText = "with your choice of two different counters on it from among menace, deathtouch, and lifelink";
    }

    private GrimdancerEffect(GrimdancerEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrimdancerEffect copy() {
        return new GrimdancerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (player == null || permanent == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose two abilities");
        choice.setChoices(choices);
        if (!player.choose(this.outcome, (Choice)choice, game)) {
            return false;
        }
        Counter counter1 = null;
        Counter counter2 = null;
        switch (choice.getChoice()) {
            case "Menace and deathtouch": {
                counter1 = CounterType.MENACE.createInstance();
                counter2 = CounterType.DEATHTOUCH.createInstance();
                break;
            }
            case "Menace and lifelink": {
                counter1 = CounterType.MENACE.createInstance();
                counter2 = CounterType.LIFELINK.createInstance();
                break;
            }
            case "Deathtouch and lifelink": {
                counter1 = CounterType.DEATHTOUCH.createInstance();
                counter2 = CounterType.LIFELINK.createInstance();
            }
        }
        permanent.addCounters(counter1, source.getControllerId(), source, game);
        permanent.addCounters(counter2, source.getControllerId(), source, game);
        return true;
    }

    static {
        choices.add("Menace and deathtouch");
        choices.add("Menace and lifelink");
        choices.add("Deathtouch and lifelink");
    }
}

