/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class GripOfAmnesiaEffect
extends OneShotEffect {
    GripOfAmnesiaEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell unless its controller exiles all cards from their graveyard";
    }

    private GripOfAmnesiaEffect(GripOfAmnesiaEffect effect) {
        super((OneShotEffect)effect);
    }

    public GripOfAmnesiaEffect copy() {
        return new GripOfAmnesiaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(source.getFirstTarget());
        if (spell != null) {
            Player controller = game.getPlayer(spell.getControllerId());
            if (controller != null && controller.chooseUse(Outcome.Benefit, "Exile all cards from your graveyard? (Otherwise " + spell.getLogName() + " will be countered)", source, game)) {
                controller.moveCards((Cards)controller.getGraveyard(), Zone.EXILED, source, game);
                game.informPlayers(controller.getLogName() + " exiles all cards from their graveyard to prevent counter effect");
            } else {
                game.getStack().counter(spell.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

