/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.effects.keyword.AmassEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterOpponentsCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;

class GrishnakhBrashInstigatorEffect
extends OneShotEffect {
    GrishnakhBrashInstigatorEffect() {
        super(Outcome.Benefit);
        this.staticText = "amass Orcs 2. When you do, until end of turn, gain control of target nonlegendary creature an opponent controls with power less than or equal to the amassed Army's power. Untap that creature. It gains haste until end of turn";
    }

    private GrishnakhBrashInstigatorEffect(GrishnakhBrashInstigatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrishnakhBrashInstigatorEffect copy() {
        return new GrishnakhBrashInstigatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = AmassEffect.doAmass((int)2, (SubType)SubType.ORC, (Game)game, (Ability)source);
        if (permanent == null) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new GainControlTargetEffect(Duration.EndOfTurn).setText("until end of turn, gain control of target nonlegendary creature an opponent controls with power less than or equal to the amassed Army's power"), false);
        ability.addEffect((Effect)new UntapTargetEffect("Untap that creature"));
        ability.addEffect((Effect)new GainAbilityTargetEffect((Ability)HasteAbility.getInstance()).setText("It gains haste until end of turn"));
        FilterOpponentsCreaturePermanent filter = new FilterOpponentsCreaturePermanent("nonlegendary creature an opponent controls with power less than or equal to the amassed Army's power");
        filter.add(Predicates.not((Predicate)SuperType.LEGENDARY.getPredicate()));
        filter.add((Predicate)new GrishnakhBrashInstigatorPredicate(permanent));
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    private static class GrishnakhBrashInstigatorPredicate
    implements Predicate<Permanent> {
        private final Permanent permanent;

        GrishnakhBrashInstigatorPredicate(Permanent permanent) {
            this.permanent = permanent;
        }

        public boolean apply(Permanent input, Game game) {
            return input.getPower().getValue() <= this.permanent.getPower().getValue();
        }
    }
}

