/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.g.GrislySigilWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GrislySigilEffect
extends OneShotEffect {
    GrislySigilEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target creature or planeswalker. If it was dealt noncombat damage this turn, {this} deals 3 damage to it and you gain 3 life. Otherwise, {this} deals 1 damage to it and you gain 1 life";
    }

    private GrislySigilEffect(GrislySigilEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrislySigilEffect copy() {
        return new GrislySigilEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int amount = GrislySigilWatcher.checkPermanent(permanent, game) ? 3 : 1;
        permanent.damage(amount, source, game);
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.gainLife(amount, game, source);
        }
        return true;
    }
}

