/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CardsInControllerGraveyardCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.g.GristTheHungerTideTokenEffect;
import mage.cards.g.GristTheHungerTideTypeEffect;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.target.Target;
import mage.target.common.TargetCreatureOrPlaneswalker;

public final class GristTheHungerTide
extends CardImpl {
    public GristTheHungerTide(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{1}{B}{G}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.GRIST);
        this.setStartingLoyalty(3);
        this.addAbility((Ability)new SimpleStaticAbility(Zone.ALL, (Effect)new GristTheHungerTideTypeEffect()));
        this.addAbility((Ability)new LoyaltyAbility((Effect)new GristTheHungerTideTokenEffect(), 1));
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DestroyTargetEffect(), false, "destroy target creature or planeswalker");
        ability.addTarget((Target)new TargetCreatureOrPlaneswalker());
        this.addAbility((Ability)new LoyaltyAbility((Effect)new DoWhenCostPaid(ability, (Cost)new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE), "Sacrifice a creature?"), -2));
        CardsInControllerGraveyardCount creatureCardsInGraveyard = new CardsInControllerGraveyardCount((FilterCard)StaticFilters.FILTER_CARD_CREATURES);
        this.addAbility(new LoyaltyAbility((Effect)new LoseLifeOpponentsEffect((DynamicValue)creatureCardsInGraveyard).setText("each opponent loses life equal to the number of creature cards in your graveyard"), -5).addHint((Hint)new ValueHint("Creature cards in your graveyard", (DynamicValue)creatureCardsInGraveyard)));
    }

    private GristTheHungerTide(GristTheHungerTide card) {
        super((CardImpl)card);
    }

    public GristTheHungerTide copy() {
        return new GristTheHungerTide(this);
    }

    public List<CardType> getCardTypeForDeckbuilding() {
        return Arrays.asList(CardType.PLANESWALKER, CardType.CREATURE);
    }

    public boolean hasSubTypeForDeckbuilding(SubType subType) {
        return subType == SubType.INSECT || super.hasSubTypeForDeckbuilding(subType);
    }
}

