/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.g.GrolnokTheOmnivoreExileEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GrolnokTheOmnivoreTriggeredAbility
extends TriggeredAbilityImpl {
    public GrolnokTheOmnivoreTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GrolnokTheOmnivoreExileEffect());
        this.setTriggerPhrase("Whenever a permanent card is put into your graveyard from your library, ");
    }

    private GrolnokTheOmnivoreTriggeredAbility(GrolnokTheOmnivoreTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GrolnokTheOmnivoreTriggeredAbility copy() {
        return new GrolnokTheOmnivoreTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        Card card = game.getCard(zEvent.getTargetId());
        if (card != null && zEvent.getToZone() == Zone.GRAVEYARD && zEvent.getFromZone() == Zone.LIBRARY && card.isOwnedBy(this.controllerId) && card.isPermanent(game)) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(card, game));
            return true;
        }
        return false;
    }
}

