/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.common.TargetControlledPermanent;

class GuardDogsEffect
extends PreventionEffectImpl {
    private TargetControlledPermanent controlledTarget;

    public GuardDogsEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, true);
        this.staticText = "Choose a permanent you control. Prevent all combat damage target creature would deal this turn if it shares a color with that permanent";
    }

    private GuardDogsEffect(GuardDogsEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.controlledTarget = new TargetControlledPermanent();
        this.controlledTarget.withNotTarget(true);
        this.controlledTarget.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public GuardDogsEffect copy() {
        return new GuardDogsEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject mageObject;
        if (!this.used && super.applies(event, source, game) && (mageObject = game.getObject(event.getSourceId())) != null && this.controlledTarget.getFirstTarget() != null) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(this.controlledTarget.getFirstTarget());
            Permanent targetPermanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
            if (permanent != null && targetPermanent != null && this.getTargetPointer().getTargets(game, source).contains(event.getSourceId()) && permanent.getColor(game).shares(targetPermanent.getColor(game))) {
                return true;
            }
        }
        return false;
    }
}

