/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;

class GuardianBeastConditionalEffect
extends ContinuousRuleModifyingEffectImpl {
    GuardianBeastConditionalEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = ", and other players can't gain control of them. This effect doesn't remove Auras already attached to those artifacts";
    }

    private GuardianBeastConditionalEffect(GuardianBeastConditionalEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public GuardianBeastConditionalEffect copy() {
        return new GuardianBeastConditionalEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.GAIN_CONTROL || event.getType() == GameEvent.EventType.ATTACH || event.getType() == GameEvent.EventType.TARGET;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Permanent targetPermanent = game.getPermanent(event.getTargetId());
        if (permanent == null || permanent.isTapped() || targetPermanent == null) {
            return false;
        }
        if (!Objects.equals(targetPermanent.getControllerId(), permanent.getControllerId())) {
            return false;
        }
        StackObject spell = game.getStack().getStackObject(event.getSourceId());
        if (event.getType() == GameEvent.EventType.GAIN_CONTROL || (event.getType() == GameEvent.EventType.ATTACH || event.getType() == GameEvent.EventType.TARGET) && spell != null && spell.isEnchantment(game) && spell.hasSubtype(SubType.AURA, game)) {
            for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_ARTIFACT_NON_CREATURE, source.getControllerId(), game)) {
                if (perm == null || !Objects.equals(perm.getId(), targetPermanent.getId()) || perm.isCreature(game)) continue;
                return true;
            }
        }
        return false;
    }
}

