/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GuardianOfTazeemEffect
extends OneShotEffect {
    GuardianOfTazeemEffect() {
        super(Outcome.Benefit);
        this.staticText = "If that land is an Island, that creature doesn't untap during its controller's next untap step";
    }

    private GuardianOfTazeemEffect(GuardianOfTazeemEffect effect) {
        super((OneShotEffect)effect);
    }

    public GuardianOfTazeemEffect copy() {
        return new GuardianOfTazeemEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent land = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        if (land != null && targetCreature != null && land.hasSubtype(SubType.ISLAND, game)) {
            DontUntapInControllersNextUntapStepTargetEffect effect = new DontUntapInControllersNextUntapStepTargetEffect("that creature");
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetCreature, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

