/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class GuildSummitEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("untapped Gates you control");

    public GuildSummitEffect() {
        super(Outcome.GainLife);
        this.staticText = "you may tap any number of untapped Gates you control. Draw a card for each Gate tapped this way";
    }

    private GuildSummitEffect(GuildSummitEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int tappedAmount = 0;
        Player you = game.getPlayer(source.getControllerId());
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        if (target.canChoose(source.getControllerId(), source, game) && target.choose(Outcome.Tap, source.getControllerId(), source.getSourceId(), source, game)) {
            for (UUID creatureId : target.getTargets()) {
                Permanent creature = game.getPermanent(creatureId);
                if (creature == null) continue;
                creature.tap(source, game);
                ++tappedAmount;
            }
        }
        if (tappedAmount > 0) {
            you.drawCards(tappedAmount, source, game);
            return true;
        }
        return false;
    }

    public GuildSummitEffect copy() {
        return new GuildSummitEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter.add((Predicate)TappedPredicate.UNTAPPED);
        filter.add((Predicate)SubType.GATE.getPredicate());
    }
}

