/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class GusthasScepterLookAtCardEffect
extends AsThoughEffectImpl {
    private final MageObjectReference mor;

    public GusthasScepterLookAtCardEffect(Card card, Game game) {
        super(AsThoughEffectType.LOOK_AT_FACE_DOWN, Duration.EndOfGame, Outcome.Benefit);
        this.mor = new MageObjectReference((MageObject)card, game);
        this.staticText = "You may look at it for as long as it remains exiled";
    }

    private GusthasScepterLookAtCardEffect(GusthasScepterLookAtCardEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.mor = effect.mor;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public GusthasScepterLookAtCardEffect copy() {
        return new GusthasScepterLookAtCardEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!this.mor.zoneCounterIsCurrent(game)) {
            this.discard();
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (exileZone == null || !exileZone.contains((Object)this.mor.getSourceId())) {
            this.discard();
            return false;
        }
        return this.mor.refersTo(objectId, game) && source.isControlledBy(affectedControllerId);
    }
}

