/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class GusthasScepterReturnEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("card you own exiled with this permanent");

    GusthasScepterReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "return a card you own exiled with {this} to your hand";
    }

    private GusthasScepterReturnEffect(GusthasScepterReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public GusthasScepterReturnEffect copy() {
        return new GusthasScepterReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile(filter, CardUtil.getExileZoneId((Game)game, (Ability)source));
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.HAND, source, game);
    }
}

