/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GuulDrazOverseerEffect
extends OneShotEffect {
    GuulDrazOverseerEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "other creatures you control get +1/+0 until end of turn. If that land is a Swamp, those creatures get +2/+0 until end of turn instead";
    }

    private GuulDrazOverseerEffect(GuulDrazOverseerEffect effect) {
        super((OneShotEffect)effect);
    }

    public GuulDrazOverseerEffect copy() {
        return new GuulDrazOverseerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent land = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller != null && land != null) {
            int boost = 1;
            if (land.hasSubtype(SubType.SWAMP, game)) {
                boost = 2;
            }
            game.addEffect((ContinuousEffect)new BoostControlledEffect(boost, 0, Duration.EndOfTurn, true), source);
            return true;
        }
        return false;
    }
}

