/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.WalkerToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class LucilleEffect
extends OneShotEffect {
    LucilleEffect() {
        super(Outcome.Benefit);
        this.staticText = "defending player sacrifices a creature. If they do, you create a Walker token";
    }

    private LucilleEffect(LucilleEffect effect) {
        super((OneShotEffect)effect);
    }

    public LucilleEffect copy() {
        return new LucilleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment == null) {
            return false;
        }
        Player player = game.getPlayer(game.getCombat().getDefendingPlayerId(equipment.getAttachedTo(), game));
        if (player == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        if (!target.canChoose(player.getId(), source, game)) {
            return false;
        }
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent.sacrifice(source, game) && new WalkerToken().putOntoBattlefield(1, game, source, source.getControllerId());
    }
}

