/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RickSteadfastLeaderChooseEffect
extends OneShotEffect {
    private static final Set<String> choices = new LinkedHashSet<String>();

    RickSteadfastLeaderChooseEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose two abilities from among first strike, vigilance, and lifelink";
    }

    private RickSteadfastLeaderChooseEffect(RickSteadfastLeaderChooseEffect effect) {
        super((OneShotEffect)effect);
    }

    public RickSteadfastLeaderChooseEffect copy() {
        return new RickSteadfastLeaderChooseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (player == null || permanent == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose two abilities");
        choice.setChoices(choices);
        if (!player.choose(this.outcome, (Choice)choice, game)) {
            return false;
        }
        game.getState().setValue(source.getSourceId() + "_rick", (Object)choice.getChoice());
        return true;
    }

    static {
        choices.add("First strike and vigilance");
        choices.add("First strike and lifelink");
        choices.add("Vigilance and lifelink");
    }
}

