/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.AttackedLastTurnWatcher;

class CantAttackIfAttackedLastTurnAllEffect
extends RestrictionEffect {
    CantAttackIfAttackedLastTurnAllEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Creatures that attacked during their controller's last turn can't attack";
    }

    private CantAttackIfAttackedLastTurnAllEffect(CantAttackIfAttackedLastTurnAllEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.isCreature(game);
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        AttackedLastTurnWatcher watcher = (AttackedLastTurnWatcher)game.getState().getWatcher(AttackedLastTurnWatcher.class);
        if (watcher != null) {
            MageObjectReference mor;
            Set attackingCreatures = watcher.getAttackedLastTurnCreatures(attacker.getControllerId());
            return !attackingCreatures.contains(mor = new MageObjectReference((MageObject)attacker, game));
        }
        return true;
    }

    public CantAttackIfAttackedLastTurnAllEffect copy() {
        return new CantAttackIfAttackedLastTurnAllEffect(this);
    }
}

