/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.cards.h.HakimLoreweaverPredicate;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HakimLoreweaverDestroyEffect
extends OneShotEffect {
    HakimLoreweaverDestroyEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy all Auras attached to {this}";
    }

    private HakimLoreweaverDestroyEffect(HakimLoreweaverDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public HakimLoreweaverDestroyEffect copy() {
        return new HakimLoreweaverDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent();
        filter.add((Predicate)SubType.AURA.getPredicate());
        filter.add((Predicate)new HakimLoreweaverPredicate(permanent));
        return new DestroyAllEffect(filter).apply(game, source);
    }
}

