/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.cards.Card;
import mage.cards.p.PakoArcaneRetriever;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.ManaPoolItem;

class HaldanAvidArcanistSpendAnyManaEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    HaldanAvidArcanistSpendAnyManaEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.Custom, Outcome.Benefit);
        this.staticText = ", and you may spend mana as though it were mana of any color to cast those spells";
    }

    private HaldanAvidArcanistSpendAnyManaEffect(HaldanAvidArcanistSpendAnyManaEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public HaldanAvidArcanistSpendAnyManaEffect copy() {
        return new HaldanAvidArcanistSpendAnyManaEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Zone zone;
        Card card = game.getCard(objectId);
        if (card == null || !source.isControlledBy(affectedControllerId) || (zone = game.getState().getZone(objectId)) != Zone.EXILED && zone != Zone.STACK || !PakoArcaneRetriever.checkWatcher(affectedControllerId, card, game)) {
            return false;
        }
        return !card.isCreature(game) && (card.getCounters(game).containsKey(CounterType.FETCH) || zone == Zone.STACK);
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        return mana.getFirstAvailable();
    }
}

