/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.TapSourceEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureSourceEffect;
import mage.abilities.keyword.WardAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;

public final class HallOfStormGiants
extends CardImpl {
    private static final FilterLandPermanent filter = new FilterLandPermanent();
    private static final Condition condition;

    public HallOfStormGiants(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.LAND}, "");
        this.addAbility((Ability)new EntersBattlefieldAbility((Effect)new TapSourceEffect(), condition, "If you control two or more other lands, {this} enters tapped.", null));
        this.addAbility((Ability)new BlueManaAbility());
        this.addAbility((Ability)new SimpleActivatedAbility((Effect)new BecomesCreatureSourceEffect((Token)new CreatureToken(7, 7, "7/7 blue Giant creature with ward {3}").withColor("U").withSubType(SubType.GIANT).withAbility((Ability)new WardAbility((Cost)new GenericManaCost(3))), CardType.LAND, Duration.EndOfTurn).setText("Until end of turn, {this} becomes a 7/7 blue Giant creature with ward {3}. It's still a land. <i>(Whenever it becomes the target of a spell or ability an opponent controls, counter it unless that player pays {3}.)</i>"), (Cost)new ManaCostsImpl("{5}{U}")));
    }

    private HallOfStormGiants(HallOfStormGiants card) {
        super((CardImpl)card);
    }

    public HallOfStormGiants copy() {
        return new HallOfStormGiants(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        condition = new PermanentsOnTheBattlefieldCondition((FilterPermanent)filter, ComparisonType.MORE_THAN, 1, true);
    }
}

