/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HallowedBurialEffect
extends OneShotEffect {
    HallowedBurialEffect() {
        super(Outcome.Neutral);
        this.staticText = "Put all creatures on the bottom of their owners' libraries";
    }

    private HallowedBurialEffect(HallowedBurialEffect effect) {
        super((OneShotEffect)effect);
    }

    public HallowedBurialEffect copy() {
        return new HallowedBurialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), source, game)) {
                controller.moveCardToLibraryWithInfo((Card)creature, source, game, Zone.BATTLEFIELD, false, true);
            }
            return true;
        }
        return false;
    }
}

