/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class HammerMageEffect
extends OneShotEffect {
    public HammerMageEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all artifacts with mana value X or less";
    }

    private HammerMageEffect(HammerMageEffect effect) {
        super((OneShotEffect)effect);
    }

    public HammerMageEffect copy() {
        return new HammerMageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterArtifactPermanent filter = new FilterArtifactPermanent();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0) + 1));
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
            permanent.destroy(source, game, false);
        }
        return true;
    }
}

