/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class HamzaGuardianOfArashinEffect
extends CostModificationEffectImpl {
    private final DynamicValue xValue;

    HamzaGuardianOfArashinEffect(DynamicValue xValue) {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Creature spells you cast cost {1} less to cast for each creature you control with a +1/+1 counter on it";
        this.xValue = xValue;
    }

    private HamzaGuardianOfArashinEffect(HamzaGuardianOfArashinEffect effect) {
        super((CostModificationEffectImpl)effect);
        this.xValue = effect.xValue;
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        int amount = this.xValue.calculate(game, source, (Effect)this);
        if (amount > 0) {
            CardUtil.adjustCost((SpellAbility)((SpellAbility)abilityToModify), (int)amount);
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof SpellAbility)) {
            return false;
        }
        Card sourceCard = game.getCard(abilityToModify.getSourceId());
        return sourceCard != null && abilityToModify.isControlledBy(source.getControllerId()) && sourceCard.isCreature(game);
    }

    public HamzaGuardianOfArashinEffect copy() {
        return new HamzaGuardianOfArashinEffect(this);
    }
}

