/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.util.RandomUtil;

class HaphazardBombardmentEndOfTurnEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    HaphazardBombardmentEndOfTurnEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy one of those permanents at random";
    }

    private HaphazardBombardmentEndOfTurnEffect(HaphazardBombardmentEndOfTurnEffect effect) {
        super((OneShotEffect)effect);
    }

    public HaphazardBombardmentEndOfTurnEffect copy() {
        return new HaphazardBombardmentEndOfTurnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return Optional.ofNullable(game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)).filter(p -> !p.isEmpty()).map(RandomUtil::randomFromCollection).filter(permanent -> permanent.destroy(source, game)).isPresent();
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
        filter.add((Predicate)CounterType.AIM.getPredicate());
        filter.add(Predicates.not((Predicate)new AbilityPredicate(IndestructibleAbility.class)));
    }
}

