/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import java.util.EnumSet;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.CardType;
import mage.game.Game;
import mage.players.Player;

enum HappilyEverAfterCondition implements Condition
{
    instance;


    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getLife() < game.getStartingLife()) {
            return false;
        }
        ObjectColor color = new ObjectColor("");
        game.getBattlefield().getAllActivePermanents(source.getControllerId()).stream().map(permanent -> permanent.getColor(game)).forEach(arg_0 -> ((ObjectColor)color).addColor(arg_0));
        if (color.getColorCount() < 5) {
            return false;
        }
        EnumSet<CardType> cardTypeEnumSet = EnumSet.noneOf(CardType.class);
        game.getBattlefield().getAllActivePermanents(source.getControllerId()).stream().map(permanent -> permanent.getCardType(game)).flatMap(Collection::stream).forEach(cardTypeEnumSet::add);
        if (cardTypeEnumSet.size() >= 6) {
            return true;
        }
        player.getGraveyard().getCards(game).stream().map(card -> card.getCardType(game)).flatMap(Collection::stream).forEach(cardTypeEnumSet::add);
        return cardTypeEnumSet.size() >= 6;
    }

    public String toString() {
        return "there are five colors among permanents you control, there are six or more card types among permanents you control and/or cards in your graveyard, and your life total is greater than or equal to your starting life total";
    }
}

