/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class HaraldUnitesTheElvesEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("an Elf or Tyvar card from your graveyard");

    HaraldUnitesTheElvesEffect() {
        super(Outcome.Benefit);
        this.staticText = "Mill three cards. You may put an Elf or Tyvar card from your graveyard onto the battlefield.";
    }

    private HaraldUnitesTheElvesEffect(HaraldUnitesTheElvesEffect effect) {
        super((OneShotEffect)effect);
    }

    public HaraldUnitesTheElvesEffect copy() {
        return new HaraldUnitesTheElvesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.millCards(3, source, game);
        TargetCardInYourGraveyard targetCard = new TargetCardInYourGraveyard(0, 1, filter, true);
        player.choose(this.outcome, (Target)targetCard, source, game);
        Card card = player.getGraveyard().get(targetCard.getFirstTarget(), game);
        if (card != null) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.ELF.getPredicate(), (Predicate)SubType.TYVAR.getPredicate()));
    }
}

