/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetSource;

class HarmsWayPreventDamageTargetEffect
extends RedirectionEffect {
    private final TargetSource damageSource;

    public HarmsWayPreventDamageTargetEffect() {
        super(Duration.EndOfTurn, 2, RedirectionEffect.UsageType.ACCORDING_DURATION);
        this.staticText = "The next 2 damage that a source of your choice would deal to you and/or permanents you control this turn is dealt to any target instead";
        this.damageSource = new TargetSource();
    }

    private HarmsWayPreventDamageTargetEffect(HarmsWayPreventDamageTargetEffect effect) {
        super((RedirectionEffect)effect);
        this.damageSource = effect.damageSource.copy();
    }

    public HarmsWayPreventDamageTargetEffect copy() {
        return new HarmsWayPreventDamageTargetEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.damageSource.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        if (object == null) {
            game.informPlayers("Couldn't find source of damage");
            return false;
        }
        if (!(object.getId().equals(this.damageSource.getFirstTarget()) || object instanceof Spell && ((Spell)object).getSourceId().equals(this.damageSource.getFirstTarget()))) {
            return false;
        }
        this.redirectTarget = (Target)source.getTargets().get(0);
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isControlledBy(source.getControllerId())) {
            return true;
        }
        Player player = game.getPlayer(event.getTargetId());
        return player != null && player.getId().equals(source.getControllerId());
    }
}

