/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HatefulEidolonTriggeredAbility
extends TriggeredAbilityImpl {
    HatefulEidolonTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private HatefulEidolonTriggeredAbility(HatefulEidolonTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public HatefulEidolonTriggeredAbility copy() {
        return new HatefulEidolonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        int auraCount = 0;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent()) {
            return false;
        }
        Permanent deadCreature = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (deadCreature.getAttachments().isEmpty()) {
            return false;
        }
        for (UUID auraId : deadCreature.getAttachments()) {
            Permanent attachment = game.getPermanentOrLKIBattlefield(auraId);
            if (!attachment.getControllerId().equals(this.controllerId) || !attachment.isEnchantment(game)) continue;
            ++auraCount;
        }
        if (auraCount == 0) {
            return false;
        }
        Player controller = game.getPlayer(this.controllerId);
        if (controller != null && controller.canRespond()) {
            this.getEffects().clear();
            DrawCardTargetEffect drawCard = new DrawCardTargetEffect(auraCount);
            drawCard.setTargetPointer((TargetPointer)new FixedTarget(this.controllerId));
            this.addEffect((Effect)drawCard);
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever an enchanted creature dies, draw a card for each Aura you controlled that was attached to it.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

