/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.HauntedAngelToken;

class HauntedAngelEffect
extends OneShotEffect {
    HauntedAngelEffect() {
        super(Outcome.Detriment);
        this.staticText = "and each other player creates a 3/3 black Angel creature token with flying.";
    }

    private HauntedAngelEffect(HauntedAngelEffect copy) {
        super((OneShotEffect)copy);
    }

    public HauntedAngelEffect copy() {
        return new HauntedAngelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID controllerId = source.getControllerId();
        HauntedAngelToken token = new HauntedAngelToken();
        for (UUID playerId : game.getState().getPlayersInRange(controllerId, game)) {
            if (playerId.equals(controllerId)) continue;
            token.putOntoBattlefield(1, game, source, playerId);
        }
        return true;
    }
}

