/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.h.HauntingEchoesPredicate;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class HauntingEchoesEffect
extends OneShotEffect {
    HauntingEchoesEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile all cards from target player's graveyard other than basic land cards. For each card exiled this way, search that player's library for all cards with the same name as that card and exile them. Then that player shuffles";
    }

    private HauntingEchoesEffect(HauntingEchoesEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        player.getGraveyard().getCards(game).stream().filter(Objects::nonNull).filter(card -> !card.isBasic(game) || !card.isLand(game)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.EXILED);
        FilterCard filter = new FilterCard("cards with the same name as a card exiled this way");
        filter.add((Predicate)new HauntingEchoesPredicate((Cards)cards));
        TargetCardInLibrary target = new TargetCardInLibrary(0, Integer.MAX_VALUE, filter);
        controller.searchLibrary(target, source, game, player.getId());
        cards.clear();
        cards.addAll((Collection)target.getTargets());
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }

    public HauntingEchoesEffect copy() {
        return new HauntingEchoesEffect(this);
    }
}

