/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class HavengulLaboratoryWatcher
extends Watcher {
    private final Map<UUID, Integer> playerMap = new HashMap<UUID, Integer>();

    HavengulLaboratoryWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SACRIFICED_PERMANENT) {
            return;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (permanent == null || !permanent.hasSubtype(SubType.CLUE, game)) {
            return;
        }
        this.playerMap.compute(event.getPlayerId(), CardUtil::setOrIncrementValue);
    }

    public void reset() {
        this.playerMap.clear();
        super.reset();
    }

    static boolean checkPlayer(UUID playerId, Game game) {
        return ((HavengulLaboratoryWatcher)game.getState().getWatcher(HavengulLaboratoryWatcher.class)).playerMap.getOrDefault(playerId, 0) >= 3;
    }
}

