/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.h.HavengulMystery;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class HavengulMysteryEffect
extends OneShotEffect {
    HavengulMysteryEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature card from your graveyard to the battlefield";
    }

    private HavengulMysteryEffect(HavengulMysteryEffect effect) {
        super((OneShotEffect)effect);
    }

    public HavengulMysteryEffect copy() {
        return new HavengulMysteryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Set<MageObjectReference> morSet;
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        String key = HavengulMystery.makeKey(source, game);
        if (game.getState().getValue(key) != null) {
            morSet = (Set)game.getState().getValue(key);
        } else {
            morSet = new HashSet();
            game.getState().setValue(key, morSet);
        }
        morSet.add(new MageObjectReference((MageObject)permanent, game));
        return true;
    }
}

