/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class HazoretsUndyingFuryEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    HazoretsUndyingFuryEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Shuffle your library, then exile the top four cards. You may cast any number of spells with mana value 5 or less from among them without paying their mana costs";
    }

    private HazoretsUndyingFuryEffect(HazoretsUndyingFuryEffect effect) {
        super((OneShotEffect)effect);
    }

    public HazoretsUndyingFuryEffect copy() {
        return new HazoretsUndyingFuryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.shuffleLibrary(source, game);
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 4));
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        game.processAction();
        cards.retainZone(Zone.EXILED, game);
        CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)filter);
        return true;
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 6));
    }
}

