/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBlockAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;

class HeadlinerScarlettEntersEffect
extends OneShotEffect {
    HeadlinerScarlettEntersEffect() {
        super(Outcome.Detriment);
        this.staticText = "creatures target player controls can't block this turn";
    }

    private HeadlinerScarlettEntersEffect(HeadlinerScarlettEntersEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeadlinerScarlettEntersEffect copy() {
        return new HeadlinerScarlettEntersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent("Creatures target player controls");
        filter.add((Predicate)new ControllerIdPredicate(source.getFirstTarget()));
        game.addEffect((ContinuousEffect)new CantBlockAllEffect(filter, Duration.EndOfTurn), source);
        return true;
    }
}

