/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.MayLookAtTargetCardEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class HeadlinerScarlettExileEffect
extends OneShotEffect {
    HeadlinerScarlettExileEffect() {
        super(Outcome.DrawCard);
        this.staticText = "exile the top card of your library face down. You may look at and play that card this turn.";
    }

    private HeadlinerScarlettExileEffect(HeadlinerScarlettExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeadlinerScarlettExileEffect copy() {
        return new HeadlinerScarlettExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((String)("HeadlinerScarlett::" + source.getSourceId() + "::" + game.getTurn()), (Game)game);
        String exileName = CardUtil.getSourceIdName((Game)game, (Ability)source) + " turn:" + game.getTurnNum();
        card.setFaceDown(true, game);
        controller.moveCardsToExile(card, source, game, false, exileId, exileName);
        if (game.getState().getZone(card.getId()) == Zone.EXILED) {
            card.setFaceDown(true, game);
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false);
            MayLookAtTargetCardEffect effect = new MayLookAtTargetCardEffect(controller.getId());
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

