/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.TargetSource;

class HealingGraceEffect
extends PreventionEffectImpl {
    protected final TargetSource targetSource;

    public HealingGraceEffect() {
        super(Duration.EndOfTurn, 3, false);
        this.targetSource = new TargetSource();
        this.staticText = "Prevent the next 3 damage that would be dealt to any target this turn by a source of your choice";
    }

    private HealingGraceEffect(HealingGraceEffect effect) {
        super((PreventionEffectImpl)effect);
        this.targetSource = effect.targetSource.copy();
    }

    public HealingGraceEffect copy() {
        return new HealingGraceEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.targetSource.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
        if (this.targetSource.getFirstTarget() != null) {
            this.targetSource.updateTarget(this.targetSource.getFirstTarget(), game);
        }
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        this.preventDamageAction(event, source, game);
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getTargetId().equals(source.getFirstTarget()) && event.getSourceId().equals(this.targetSource.getFirstTarget()) && this.targetSource.isLegal(source, game);
    }
}

