/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class HeartWolfDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    public HeartWolfDelayedTriggeredAbility() {
        super((Effect)new SacrificeSourceEffect(), Duration.EndOfTurn, false);
    }

    private HeartWolfDelayedTriggeredAbility(HeartWolfDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() == Zone.BATTLEFIELD && zEvent.getTarget() != null && zEvent.getTargetId().equals(this.getTargets().getFirstTarget())) {
            this.getTargets().clear();
            return true;
        }
        return false;
    }

    public HeartWolfDelayedTriggeredAbility copy() {
        return new HeartWolfDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "When that creature leaves the battlefield this turn, sacrifice {this}.";
    }
}

