/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class HeartstoneEffect
extends CostModificationEffectImpl {
    private static final String effectText = "Activated abilities of creatures cost {1} less to activate. This effect can't reduce the mana in that cost to less than one mana";

    public HeartstoneEffect() {
        super(Duration.Custom, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = effectText;
    }

    private HeartstoneEffect(HeartstoneEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Player controller = game.getPlayer(abilityToModify.getControllerId());
        if (controller != null) {
            int reduceMax = CardUtil.calculateActualPossibleGenericManaReduction((Mana)abilityToModify.getManaCostsToPay().getMana(), (int)1, (int)1);
            if (reduceMax <= 0) {
                return true;
            }
            CardUtil.reduceCost((Ability)abilityToModify, (int)reduceMax);
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (abilityToModify.isActivatedAbility()) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(abilityToModify.getSourceId());
            return permanent != null && permanent.isCreature(game);
        }
        return false;
    }

    public HeartstoneEffect copy() {
        return new HeartstoneEffect(this);
    }
}

