/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class HeavenlyBlademasterEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent("Aura or Equipment you control");

    public HeavenlyBlademasterEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may attach any number of Auras and Equipment you control to it";
    }

    private HeavenlyBlademasterEffect(HeavenlyBlademasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeavenlyBlademasterEffect copy() {
        return new HeavenlyBlademasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || sourcePermanent == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        for (UUID targetId : target.getTargets()) {
            sourcePermanent.addAttachment(targetId, source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.AURA.getPredicate(), (Predicate)SubType.EQUIPMENT.getPredicate()));
    }
}

