/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.filter.common.FilterAttackingCreature;
import mage.game.Game;
import mage.game.events.DamagePlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class HeavyFogEffect
extends PreventionEffectImpl {
    private static final FilterAttackingCreature filter = new FilterAttackingCreature();

    HeavyFogEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false);
        this.staticText = "Prevent all damage that would be dealt to you this turn by attacking creatures";
    }

    private HeavyFogEffect(HeavyFogEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public HeavyFogEffect copy() {
        return new HeavyFogEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game) && event instanceof DamagePlayerEvent && event.getAmount() > 0) {
            Permanent permanent;
            DamagePlayerEvent damageEvent = (DamagePlayerEvent)event;
            if (event.getTargetId().equals(source.getControllerId()) && (permanent = game.getPermanentOrLKIBattlefield(damageEvent.getSourceId())) != null && filter.match((Object)permanent, game)) {
                return true;
            }
        }
        return false;
    }
}

