/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;

class HedronAlignmentEffect
extends OneShotEffect {
    private static final FilterPermanent filterPermanent = new FilterPermanent();
    private static final FilterCard filterCard = new FilterCard();

    public HedronAlignmentEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may reveal your hand. If you do, you win the game if you own a card named Hedron Alignment in exile, in your hand, in your graveyard, and on the battlefield";
    }

    private HedronAlignmentEffect(HedronAlignmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public HedronAlignmentEffect copy() {
        return new HedronAlignmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            CardsImpl cardsToReveal = new CardsImpl();
            controller.revealCards(sourceObject.getIdName(), (Cards)cardsToReveal, game);
            if (!game.getBattlefield().contains(filterPermanent, source, game, 1)) {
                return true;
            }
            if (controller.getHand().getCards(filterCard, controller.getId(), source, game).isEmpty()) {
                return true;
            }
            if (controller.getGraveyard().getCards(filterCard, controller.getId(), source, game).isEmpty()) {
                return true;
            }
            if (game.getExile().getCardsOwned(filterCard, controller.getId(), source, game).isEmpty()) {
                return true;
            }
            controller.won(game);
            return true;
        }
        return false;
    }

    static {
        filterPermanent.add((Predicate)new NamePredicate("Hedron Alignment"));
        filterPermanent.add((ObjectSourcePlayerPredicate)TargetController.YOU.getOwnerPredicate());
        filterCard.add((Predicate)new NamePredicate("Hedron Alignment"));
        filterCard.add((ObjectSourcePlayerPredicate)TargetController.YOU.getOwnerPredicate());
    }
}

