/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HedronMatrixEffect
extends ContinuousEffectImpl {
    HedronMatrixEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Equipped creature gets +X/+X, where X is its mana value";
    }

    private HedronMatrixEffect(HedronMatrixEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public HedronMatrixEffect copy() {
        return new HedronMatrixEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature;
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment != null && equipment.getAttachedTo() != null && (creature = game.getPermanent(equipment.getAttachedTo())) != null) {
            creature.addPower(creature.getManaValue());
            creature.addToughness(creature.getManaValue());
        }
        return true;
    }
}

