/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;

class HelbruteEffect
extends AsThoughEffectImpl {
    private static final FilterCard filter = new FilterCard("another creature card from your graveyard");

    public HelbruteEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "you may cast {this} from your graveyard by exiling another creature card from your graveyard in addition to paying its other costs.";
    }

    private HelbruteEffect(HelbruteEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public HelbruteEffect copy() {
        return new HelbruteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.getSourceId().equals(objectId) || !source.isControlledBy(affectedControllerId) || game.getState().getZone(objectId) != Zone.GRAVEYARD) {
            return false;
        }
        Player controller = game.getPlayer(affectedControllerId);
        if (controller == null) {
            return false;
        }
        CostsImpl costs = new CostsImpl();
        costs.add((Object)new ExileFromGraveCost(new TargetCardInYourGraveyard(filter)));
        controller.setCastSourceIdWithAlternateMana(objectId, (ManaCosts)new ManaCostsImpl("{3}{B}{R}"), (Costs)costs, MageIdentifier.HelbruteAlternateCast);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

