/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.cards.h.HelgaSkittishSeerManaBuilder;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class HelgaSkittishSeerManaEffect
extends ManaEffect {
    private final ConditionalManaBuilder manaBuilder = new HelgaSkittishSeerManaBuilder();
    private final DynamicValue power;

    HelgaSkittishSeerManaEffect(DynamicValue power) {
        this.power = power;
        this.staticText = "Add X mana of any one color, where X is {this}'s power. " + this.manaBuilder.getRule();
    }

    private HelgaSkittishSeerManaEffect(HelgaSkittishSeerManaEffect effect) {
        super((ManaEffect)effect);
        this.power = effect.power.copy();
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game != null) {
            int currentPower = this.power.calculate(game, source, (Effect)this);
            netMana.add((Mana)this.manaBuilder.setMana(Mana.BlackMana((int)currentPower), source, game).build(new Object[0]));
            netMana.add((Mana)this.manaBuilder.setMana(Mana.BlueMana((int)currentPower), source, game).build(new Object[0]));
            netMana.add((Mana)this.manaBuilder.setMana(Mana.RedMana((int)currentPower), source, game).build(new Object[0]));
            netMana.add((Mana)this.manaBuilder.setMana(Mana.GreenMana((int)currentPower), source, game).build(new Object[0]));
            netMana.add((Mana)this.manaBuilder.setMana(Mana.WhiteMana((int)currentPower), source, game).build(new Object[0]));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ChoiceColor choice = new ChoiceColor();
            if (!controller.choose(Outcome.PutManaInPool, (Choice)choice, game)) {
                return mana;
            }
            Mana chosen = choice.getMana(this.power.calculate(game, source, (Effect)this));
            return (Mana)this.manaBuilder.setMana(chosen, source, game).build(new Object[0]);
        }
        return mana;
    }

    public HelgaSkittishSeerManaEffect copy() {
        return new HelgaSkittishSeerManaEffect(this);
    }
}

