/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.h.HenryWuInGenGeneticistEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HenryWuInGenGeneticistTriggeredAbility
extends TriggeredAbilityImpl {
    public static final FilterPermanent filterNonHumans = new FilterCreaturePermanent("non-Human creature");

    HenryWuInGenGeneticistTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
        this.addEffect((Effect)new HenryWuInGenGeneticistEffect());
        this.setTriggerPhrase("Whenever a creature you control exploits a " + filterNonHumans.getMessage() + ", ");
    }

    private HenryWuInGenGeneticistTriggeredAbility(HenryWuInGenGeneticistTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.EXPLOITED_CREATURE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent exploiter = game.getPermanentOrLKIBattlefield(event.getSourceId());
        Permanent exploited = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (exploiter != null && exploited != null && exploiter.isCreature(game) && exploiter.isControlledBy(this.getControllerId()) && filterNonHumans.match(exploited, this.getControllerId(), (Ability)this, game)) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(exploited.getId(), game));
            return true;
        }
        return false;
    }

    public HenryWuInGenGeneticistTriggeredAbility copy() {
        return new HenryWuInGenGeneticistTriggeredAbility(this);
    }

    static {
        filterNonHumans.add(Predicates.not((Predicate)SubType.HUMAN.getPredicate()));
    }
}

