/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Objects;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HereticsPunishmentEffect
extends OneShotEffect {
    HereticsPunishmentEffect() {
        super(Outcome.Damage);
        this.staticText = "Choose any target, then mill three cards. {this} deals damage to that permanent or player equal to the highest mana value among the milled cards";
    }

    private HereticsPunishmentEffect(HereticsPunishmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int maxCost = controller.millCards(3, source, game).getCards(game).stream().filter(Objects::nonNull).mapToInt(MageObject::getManaValue).max().orElse(0);
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            permanent.damage(maxCost, source.getSourceId(), source, game, false, true);
            return true;
        }
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            targetPlayer.damage(maxCost, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }

    public HereticsPunishmentEffect copy() {
        return new HereticsPunishmentEffect(this);
    }
}

