/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetSacrifice;

class HewTheEntwoodEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("artifact and/or land cards");

    HewTheEntwoodEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice any number of lands. Reveal the top X cards of your library, where X is the number of lands sacrificed this way. Choose any number of artifact and/or land cards revealed this way. Put all nonland cards chosen this way onto the battlefield, then put all land cards chosen this way onto the battlefield tapped, then put the rest on the bottom of your library in a random order";
    }

    private HewTheEntwoodEffect(HewTheEntwoodEffect effect) {
        super((OneShotEffect)effect);
    }

    public HewTheEntwoodEffect copy() {
        return new HewTheEntwoodEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_LAND);
        player.choose(this.outcome, (Target)target, source, game);
        int count = 0;
        for (UUID targetId : target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null || !permanent.sacrifice(source, game)) continue;
            ++count;
        }
        if (count < 1) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, count));
        player.revealCards(source, (Cards)cards, game);
        TargetCardInLibrary targetCard = new TargetCardInLibrary(0, Integer.MAX_VALUE, filter);
        player.choose(this.outcome, (Cards)cards, (TargetCard)targetCard, source, game);
        CardsImpl toPlay = new CardsImpl((Collection)targetCard.getTargets());
        player.moveCards(toPlay.getCards((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game), Zone.BATTLEFIELD, source, game);
        player.moveCards(toPlay.getCards((FilterCard)StaticFilters.FILTER_CARD_LAND, game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.LAND.getPredicate()));
    }
}

