/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HiddenBladeEffect
extends OneShotEffect {
    HiddenBladeEffect() {
        super(Outcome.Benefit);
        this.staticText = "if that creature is an Assassin, it gains deathtouch until end of turn";
    }

    private HiddenBladeEffect(HiddenBladeEffect effect) {
        super((OneShotEffect)effect);
    }

    public HiddenBladeEffect copy() {
        return new HiddenBladeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || !permanent.hasSubtype(SubType.ASSASSIN, game)) {
            return false;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)DeathtouchAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

