/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceIsEnchantmentCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BecomesCreatureSourceEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;

class HiddenHerdAbility
extends TriggeredAbilityImpl {
    public HiddenHerdAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BecomesCreatureSourceEffect((Token)new CreatureToken(3, 3, "3/3 Beast creature", new SubType[]{SubType.BEAST}), null, Duration.WhileOnBattlefield), false);
        this.withInterveningIf((Condition)SourceIsEnchantmentCondition.instance);
        this.withRuleTextReplacement(true);
        this.setTriggerPhrase("When an opponent plays a nonbasic land, ");
    }

    private HiddenHerdAbility(HiddenHerdAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public HiddenHerdAbility copy() {
        return new HiddenHerdAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LAND_PLAYED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent land = game.getPermanentOrLKIBattlefield(event.getTargetId());
        return land != null && game.getOpponents(this.getControllerId()).contains(event.getPlayerId()) && !land.isBasic(game);
    }
}

