/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashSet;
import java.util.Objects;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class HighcliffFelidarEffect
extends OneShotEffect {
    HighcliffFelidarEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each opponent, choose a creature with the greatest power among creatures that player controls. Destroy those creatures.";
    }

    private HighcliffFelidarEffect(HighcliffFelidarEffect effect) {
        super((OneShotEffect)effect);
    }

    public HighcliffFelidarEffect copy() {
        return new HighcliffFelidarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashSet toDestroy = new HashSet();
        game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).forEachOrdered(opponent -> {
            int maxPower = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, opponent.getId(), game).stream().map(MageObject::getPower).mapToInt(MageInt::getValue).max().orElse(Integer.MIN_VALUE);
            if (maxPower > Integer.MIN_VALUE) {
                FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with the greatest power controlled by " + opponent.getName());
                filter.add((Predicate)new ControllerIdPredicate(opponent.getId()));
                filter.add((Predicate)new PowerPredicate(ComparisonType.EQUAL_TO, maxPower));
                TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                target.withNotTarget(true);
                if (controller.choose(this.outcome, (Target)target, source, game)) {
                    toDestroy.add(target.getFirstTarget());
                }
            }
        });
        toDestroy.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).forEachOrdered(permanent -> permanent.destroy(source, game, false));
        return true;
    }
}

